# Type plot.py help for help on valid entries and format of this file
###################################################################################################################
# initial image file settings
:imagefile	IMAGENAME
:dpi		325

:panel          (2,3,1);domain=US-;proj=ced;extend=15
:map            name=ne_50m_ocean;linecolor=75,75,75,255;fillcolor=black;linewidth=.25
:gribfile       name=GRIBFILE;gribfield=ugrd,250 mb;windtype=mag
:plottype       fill;scale=1.944;fillint=0,75,100,125,150,175,200,250;fillmap=$SCRIPTS/pycommon/fills/250mb_kts.pycol;cbarloc=right;cbarcolor=200,200,200,255;white;cbarfontsize=2.5;cbarsize=.2
:gribfile	name=GRIBFILE;gribfield=ugrd,250 mb;windtype=barb
:plottype       barb;scale=1.944;barbsize=3;barbcolor=yellow;barbwidth=.1;skip=20
:gribfile	name=GRIBFILE;gribfield=hgt,:250 mb
:plottype	contour;scale=/10;contint=980/1116/12;contcolor=cyan;contwidth=.3;contfontcolor=cyan;contfontsize=3
:map            name=ne_50m_admin_0_countries;linecolor=75,75,75,255;fillcolor=none;linewidth=.25
:map            name=ne_50m_admin_1_states_provinces;linecolor=75,75,75,255;fillcolor=none;linewidth=.25
:map            name=ne_50m_lakes;linecolor=75,75,75,255;fillcolor=none;linewidth=.25
:latlon		latlonwidth=.25;latloncolor=25,25,25,255;latlontextsize=0;latlonlatfreq=10;latlonlonfreq=10
:text		v"vhhc""vampm" "vdayc" "vmmc"/"vddc"/"vyyyyc" GFS "gymd""gcyc"f"gfhr" 250mb hgt/wind kts(.01,.02);fontcolor=white;fontsize=3;fontstyle=b

:panel          (2,3,2);domain=US;extend=15
:map            name=ne_50m_ocean;linecolor=75,75,75,255;fillcolor=black;linewidth=.25
:gribfile       name=GRIBFILE;gribfield=absv,:500 mb
:plottype       fill;scale=100000;fillint=-999,15,25,35,45,55,65,90;fillmap=$SCRIPTS/pycommon/fills/absvor.pycol;cbarloc=right;cbarcolor=200,200,200,255;cbarfontsize=2.5;cbarsize=.2
:map            name=ne_50m_admin_0_countries;linecolor=75,75,75,255;fillcolor=none;linewidth=.25
:map            name=ne_50m_admin_1_states_provinces;linecolor=75,75,75,255;fillcolor=none;linewidth=.25
:map            name=ne_50m_lakes;linecolor=75,75,75,255;fillcolor=none;linewidth=.25
:gribfile       name=GRIBFILE;gribfield=HGT,:500 mb
:plottype       contour;scale=/10;contint=450/630/6;contcolor=cyan;contwidth=.3;contfontcolor=cyan;contfontsize=3
:gribfile       name=GRIBFILE;gribfield=prmsl
:plottype       contour;scale=/100;contint=900/1060/4;contcolor=white;contwidth=.1;contfontcolor=white;contfontsize=2.5;contsmooth=3
:latlon         latlonwidth=.25;latloncolor=25,25,25,255;latlontextsize=0;latlonlatfreq=10;latlonlonfreq=10
:text           v"vhhc""vampm" "vdayc" "vmmc"/"vddc"/"vyyyyc" GFS "gymd""gcyc"f"gfhr" 500mb hgt/absv PMSL(.01,.02);fontcolor=white;fontsize=3;fontstyle=b

:panel          (2,3,3);domain=FE-;proj=ced
:map            name=ne_50m_ocean;linecolor=25,25,25,255;fillcolor=black;linewidth=.25
:gribfile       name=GRIBFILE;gribfield=PWAT
:plottype       fill;scale=/25.4;fillint=0,.25,.50,.75,1,1.25,1.5,2,2.5,3,3.5,4,5,6,12;fillmap=$SCRIPTS/pycommon/fills/pw_in.pycol;cbarloc=right;cbarcolor=200,200,200,255;cbarfontsize=2.5;cbarsize=.2
:map            name=ne_50m_admin_0_countries;linecolor=25,25,25,255;fillcolor=none;linewidth=.25
:map            name=ne_50m_admin_1_states_provinces;linecolor=25,25,25,255;fillcolor=none;linewidth=.25
:map            name=ne_50m_lakes;linecolor=25,25,25,255;fillcolor=none;linewidth=.25
:shapefile      name=$DATA/shapefiles/fe.dbf;linecolor=25,25,25,255;fillcolor=none;linewidth=.25
:gribfile       name=GRIBFILE;gribfield=HGT,:850 mb
:plottype       contour;scale=-1000;contint=230/650/30;contcolor=white;contwidth=.3;contfontcolor=white;contfontsize=3
:gribfile       name=GRIBFILE;gribfield=TMP,:850 mb
:plottype       contour;scale=C;contint=-40/-5/5;contcolor=0,200,200,255;contwidth=.3;contfontcolor=cyan;contfontsize=3;contstyle=dashed
:plottype       contour;scale=C;contint=0/0/1;contcolor=255,150,150,255;contwidth=.5;contfontcolor=255,150,150,255;contfontsize=3;contstyle=dotted
:plottype       contour;scale=C;contint=5/40/5;contcolor=255,80,80,255;contwidth=.3;contfontcolor=255,80,80,255;contfontsize=3
:gribfile       name=GRIBFILE;gribfield=ugrd,850 mb;windtype=barb
:plottype       barb;scale=1.944;barbsize=2.6;barbcolor=150,150,150,255;barbwidth=.1;skip=5
:text           v"vhhc""vampm" "vdayc" "vmmc"/"vddc"/"vyyyyc" GFS "gymd""gcyc"f"gfhr" 850mb hgt/tmpc/kts/PW in(.01,.02);fontcolor=white;fontsize=3;fontstyle=b

:panel          (2,3,4);domain=FE-;proj=ced
:map            name=ne_50m_ocean;linecolor=16,78,139,255;fillcolor=black;linewidth=.25
:map            name=ne_50m_admin_0_countries;linecolor=16,78,139,255;fillcolor=black;linewidth=.25
:gribmath      	g1=GRIBFILE;gribfield=APCP,:BUCKET1;g2=GFILE2;gribfield=APCP,:BUCKET2;math=-
:plottype       fill;scale=/25.4;fillint=0,.001,.01,.10,.25,.50,.75,1,1.5,2,2.5,3,6,9,12,24;fillmap=$SCRIPTS/pycommon/fills/qpf_in.pycol;cbarloc=right;cbarcolor=200,200,200,255;cbarfontsize=2.5;cbarsize=.2
:map            name=ne_50m_admin_0_countries;linecolor=16,78,139,255;fillcolor=none;linewidth=.25
:map            name=ne_50m_admin_1_states_provinces;linecolor=16,78,139,255;fillcolor=none;linewidth=.25
:map            name=ne_50m_lakes;linecolor=16,78,139,255;fillcolor=none;linewidth=.25
:shapefile      name=$DATA/shapefiles/fe.dbf;linecolor=16,78,139,255;fillcolor=none;linewidth=.25
:gribmath	g1=GRIBFILE;gribfield=HGT,:500 mb;g2=GRIBFILE;gribfield=HGT,:1000 mb;math=-
:plottype       contour;scale=/10;contint=450/534/6;contcolor=xff00ffff;contwidth=.3;contfontcolor=xff00ffff;contfontsize=3;contstyle=dashed
:plottype       contour;scale=/10;contint=540/540/6;contcolor=x00ffffff;contwidth=.3;contfontcolor=x00ffffff;contfontsize=3;contstyle=dashed
:plottype       contour;scale=/10;contint=546/630/6;contcolor=xff5555ff;contwidth=.3;contfontcolor=xff5555ff;contfontsize=3;contstyle=dashed
:gribfile       name=GRIBFILE;gribfield=prmsl
:plottype       contour;scale=/100;contint=900/1060/4;contcolor=white;contwidth=.3;contfontcolor=white;contfontsize=3;contsmooth=3
:gribfile       name=GRIBFILE;gribfield=ugrd,:10 m above;windtype=barb
:plottype       barb;scale=1.944;barbsize=2.6;barbcolor=125,125,125,255;barbwidth=.1;skip=5
:text           v"vhhc""vampm" "vdayc" "vmmc"/"vddc"/"vyyyyc" GFS "gymd""gcyc"f"gfhr" PMSL/1000-500mb thk/3h QPF/10m kts(.01,.02);fontcolor=white;fontsize=2.5;fontstyle=b

:panel          (2,3,5);domain=FE;proj=ced
:map            name=ne_50m_ocean;linecolor=75,75,75,255;fillcolor=black;linewidth=.5
:map            name=ne_50m_admin_0_countries;linecolor=75,75,75,255;fillcolor=black;linewidth=.5
:gribfile	name=GRIBFILE;gribfield=CAPE,surface
:plottype       fill;fillint=0,100,250,500,1000,1500,2000,3000,4000,5000,6000;fillmap=$SCRIPTS/pycommon/fills/cape.pycol;cbarloc=right;cbarcolor=200,200,200,255;cbarfontsize=2.5;cbarsize=.2
:map            name=ne_50m_admin_1_states_provinces;linecolor=75,75,75,255;fillcolor=none;linewidth=.5
:map            name=ne_50m_lakes;linecolor=75,75,75,255;fillcolor=none;linewidth=.5
:shapefile      name=$DATA/shapefiles/fe.dbf;linecolor=75,75,75,255;fillcolor=none;linewidth=.50
:gribfile       name=GRIBFILE;gribfield=CIN,surface
:plottype	contour;fillint=-100,-50,-10,-1;contcolor=x999999ff;contwidth=.2;contfontcolor=x999999ff;contfontsize=2.5
:gribfile       name=GRIBFILE;gribfield=HLCY
:plottype       contour;contint=100/400/100;contcolor=red;contwidth=.2;contfontcolor=red;contfontsize=2.5
:gribfile       name=GRIBFILE;gribfield=ugrd,500 mb;windtype=barb
:plottype       barb;scale=1.944;barbsize=4;barbcolor=xff0000ff;barbwidth=.2;skip=5
:gribfile       name=GRIBFILE;gribfield=ugrd,700 mb;windtype=barb
:plottype       barb;scale=1.944;barbsize=3.75;barbcolor=xffff00ff;barbwidth=.2;skip=5
:gribfile       name=GRIBFILE;gribfield=ugrd,850 mb;windtype=barb
:plottype       barb;scale=1.944;barbsize=3.5;barbcolor=x00ff00ff;barbwidth=.2;skip=5
:gribfile       name=GRIBFILE;gribfield=ugrd,:10 m above;windtype=barb
:plottype       barb;scale=1.944;barbsize=3.25;barbcolor=x00ffffff;barbwidth=.2;skip=5
:gribfile       name=GRIBFILE;gribfield=prmsl
:plottype       contour;scale=/100;contint=900/1060/4;contcolor=white;contwidth=.3;contfontcolor=white;contfontsize=3;contsmooth=3
:text           v"vhhc""vampm" "vdayc" "vmmc"/"vddc"/"vyyyyc" GFS "gymd""gcyc"f"gfhr" CAPE CIN HLCY WIND 700y 850g 10m cyan PMSL(.01,.02);fontcolor=white;fontsize=2.25;fontstyle=b

:panel          (2,3,6);domain=FE-;proj=ced
:map            name=ne_50m_ocean;linecolor=16,78,139,255;fillcolor=black;linewidth=.25
:map            name=ne_50m_admin_0_countries;linecolor=16,78,139,255;fillcolor=black;linewidth=.25
:gribfile       name=GRIBFILE;gribfield=high cloud layer,hour fcst
:plottype       fill;fillint=0,50,90,125;fillmap=$SCRIPTS/pycommon/fills/hicld_cyan.pycol
:plottype       contour;contint=30/31/30;contcolor=cyan;contwidth=.3;contfontcolor=x00000000
:gribfile       name=GRIBFILE;gribfield=middle cloud layer,hour fcst
:plottype       fill;fillint=0,60,90,125;fillmap=$SCRIPTS/pycommon/fills/medcld_yellow.pycol
:plottype       contour;contint=50/51/50;contcolor=yellow;contwidth=.3;contfontcolor=x00000000
:gribfile       name=GRIBFILE;gribfield=low cloud layer,hour fcst
:plottype       fill;fillint=0,80,90,125;fillmap=$SCRIPTS/pycommon/fills/lowcld_red.pycol
:plottype       contour;contint=70/71/70;contcolor=red;contwidth=.3;contfontcolor=x00000000
:gribfile       name=GRIBFILE;gribfield=prmsl
:plottype       contour;scale=/100;contint=900/1060/4;contcolor=white;contwidth=.3;contfontcolor=white;contfontsize=3;contsmooth=3
:map            name=ne_50m_admin_1_states_provinces;linecolor=16,78,139,255;fillcolor=none;linewidth=.25
:map            name=ne_50m_lakes;linecolor=16,78,139,255;fillcolor=none;linewidth=.25
:shapefile      name=$DATA/shapefiles/fe.dbf;linecolor=16,78,139,255;fillcolor=none;linewidth=.25
:text           v"vhhc""vampm" "vdayc" "vmmc"/"vddc"/"vyyyyc" GFS "gymd""gcyc"f"gfhr" cloud low red mid yel hi cyan/pmsl(.01,.02);fontcolor=white;fontsize=2.5;fontstyle=b

:vpad		-.64 
:hpad		0.09
